/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui;

import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;

public class RubyDebugHover
implements ITextHover,
ITextHoverExtension2 {
    private static IDebugModelPresentation modelPresentation;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object info = this.getHoverInfo2(textViewer, hoverRegion);
        return info != null ? info.toString() : null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document;
        IRubyStackFrame frame = this.getFrame();
        if (frame != null && (document = textViewer.getDocument()) != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                try {
                    IVariable[] variables = frame.getVariables();
                    if (variables != null) {
                        IVariable[] iVariableArray = variables;
                        int n = variables.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IVariable variable = iVariableArray[n2];
                            if (variableName.equals(variable.getName())) {
                                return this.getVariableText(variable);
                            }
                            ++n2;
                        }
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    private IRubyStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IRubyStackFrame)adaptable.getAdapter(IRubyStackFrame.class);
        }
        return null;
    }

    private String getVariableText(IVariable variable) {
        StringBuilder sb = new StringBuilder();
        IDebugModelPresentation modelPresentation = RubyDebugHover.getModelPresentation();
        sb.append("<p><pre>");
        String variableText = modelPresentation.getText((Object)variable);
        sb.append(RubyDebugHover.replaceHTMLChars(variableText));
        sb.append("</pre></p>");
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuilder sb = new StringBuilder(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(character);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static IDebugModelPresentation getModelPresentation() {
        if (modelPresentation == null) {
            modelPresentation = DebugUITools.newDebugModelPresentation((String)RubyDebugModel.getModelIdentifier());
            modelPresentation.setAttribute("org.eclipse.debug.ui.displayVariableTypeNames", (Object)Boolean.TRUE);
        }
        return modelPresentation;
    }
}

